<?php

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\User\Events\UserDisabledEvent;

/**
 * User disabled listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserDisabledListener implements ShouldQueue
{
    /**
     * @inheritDoc
     */
    public function handle(UserDisabledEvent $event): void
    {
        $user = User::find($event->userUuid);

        if (! $user instanceof User) {
            return;
        }

        Log::info('[user-disabled] Suppression des pivots de <'.$event->userUuid.'>');

        DB::table('inside_pivots')->where('related_uuid', $event->userUuid)->where(
            'related_type',
            type_to_class('users')
        )->delete();
    }
}
