<?php

namespace Inside\Content\Listeners;

use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentUpdatingEvent;

class SetIsMaintenanceListener
{
    public function handle(ContentUpdatingEvent|ContentCreatedEvent $event): void
    {
        $user = $event->model;
        if ($user->getContentTypeAttribute() === 'users' && is_null($user->is_maintenance)) {
            $user->is_maintenance = false;
            $user->save();
        }
    }
}
