<?php

namespace Inside\Content\Listeners;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ExportCompletedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

/**
 * Class NotifyUserOfCompletedExport
 */
class NotifyUserOfCompletedExport extends BaseNotificationListener implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    /** @var User|null */
    public $user;

    /** @var string */
    public $path;

    /** @var string */
    public $disk;

    public function __construct(User $user, string $path, string $disk)
    {
        $this->user = $user;
        $this->path = $path;
        $this->disk = $disk;
    }

    public function handle(): void
    {
        if (! $this->user) {
            return;
        }
        /**
         * broadcast the event
         */
        event(new ExportCompletedEvent($this->disk, $this->path, $this->user));

        /**
         * On non instance with no broadcasting, use classique notification
         */
        $types = NotificationType::where('action', 'export')->get();

        foreach ($types as $type) {
            $this->route = $this->user;
            $link = Storage::disk($this->disk)->url($this->path);
            $this->notify($type, $this->user, null, ['extra' => ['link' => $link]]);
        }
    }
}
