<?php

namespace Inside\Content\Listeners;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\News;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationSubscriber;

class NewsCategoriesUpdatedListener extends BaseNotificationListener
{
    private function notifyUsers(string $via, array $conditions, News $model): void
    {
        NotificationSubscriber::query()
            ->whereHas(
                'notificationType',
                fn (Builder $notificationType) => $notificationType
                    ->where('action', 'follow')
                    ->where('via', $via)
                    ->whereIn('condition', $conditions)
            )
            ->groupBy(['user_uuid'])
            ->each(function (NotificationSubscriber $subscriber) use ($model) {
                $user = User::find($subscriber->user_uuid);

                if ($this->checkConditions($subscriber->notificationType, $model, $user) === false) {
                    return;
                }

                $this->route = $user;
                $this->notify($subscriber->notificationType, $user, $model);
            });
    }

    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof News) {
            return;
        }

        if (! $model->isDirty('status') || ! $model->status) {
            return;
        }

        $categories = $model->newsCategories;
        $conditions = [];
        foreach ($categories as $category) {
            $conditions[] = 'news_categories:'.$category->uuid.'|status:1';
        }
        $this->notifyUsers('web', $conditions, $model);
        $this->notifyUsers('email', $conditions, $model);
    }
}
