<?php

declare(strict_types=1);

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Contracts\WelcomeToTheJungleContentsManager;
use Inside\Content\Events\ContentFullyUpdatedEvent;

final class JobOffersUpdatedListener implements ShouldQueue
{
    public function __construct(private WelcomeToTheJungleContentsManager $welcomeToTheJungleContentsManager)
    {
    }

    public function handle(ContentFullyUpdatedEvent $event): void
    {
        $model = $event->model;

        if ($this->welcomeToTheJungleContentsManager->isWTTJEnabled() && $model->content_type === 'job_offers' && $model->uuid) {
            $this->welcomeToTheJungleContentsManager->updateJobOfferApplicationFormTitle($model->uuid);
        }
    }
}
