<?php

declare(strict_types=1);

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Contracts\WelcomeToTheJungleContentsManager;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Models\Contents\Forms;
use Inside\Host\Bridge\BridgeContent;

final class JobOffersFormTemplateUpdatedListener implements ShouldQueue
{
    public function __construct(private WelcomeToTheJungleContentsManager $welcomeToTheJungleContentsManager)
    {
    }

    public function handle(ContentFullyUpdatedEvent $event): void
    {
        $model = $event->model;

        if (
            $this->welcomeToTheJungleContentsManager->isWTTJEnabled()
            && $model->content_type === 'forms'
            && $model->job_offers_form_template
        ) {
            $this->welcomeToTheJungleContentsManager->updateJobOffersApplicationForms($model->langcode);
        }
    }
}
