<?php

declare(strict_types=1);

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Contracts\RevisionService;
use Inside\Content\Models\Content;

class GenerateRevision extends ContentFullySavedWithImagesListener implements ShouldQueue
{
    public string $queue;

    public function __construct(
        protected RevisionService $service
    ) {
        $this->queue = get_high_priority_queue_name() ?? 'default';
    }

    public function handleContent(Content $content): void
    {
        $this->service->createNewRevision($content);
    }
}
