<?php

namespace Inside\Content\Listeners;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Content;

class ContentInsertedListener extends BaseContentListener
{
    use QueuePublishContent;

    /**
     * NOTE: we are using FullyInserted event instead of inserted one
     * because comment never send inserted event
     */
    public function handle(ContentFullyInsertedEvent $event): void
    {
        if ($event->model instanceof Content) {
            $this->queuePublishContent($event->model);
        }
        $model = $event->model;
        $this->clearCommentsCache($model);
    }
}
