<?php

namespace Inside\Content\Listeners;

use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Facades\ContentCleaner;

/**
 * Content deleted listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentDeletedListener extends BaseContentListener
{
    public function handle(ContentDeletedEvent $event): void
    {
        ContentCleaner::clean($event->model);
        if ($event->model->content_type === 'comments') {
            $this->clearCommentsCache($event->model);
        }

        $this->forgetCache($event->model);
    }
}
