<?php

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\BirthdayWishesSendEvent;
use Inside\Content\Events\ContentCacheIsNotValidAnyMoreEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

/**
 * BirthdayWishesSendListener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class BirthdayWishesSendListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(BirthdayWishesSendEvent $event): void
    {
        $type = NotificationType::where('action', 'birthday')->first();
        if (! $type) {
            return;
        }

        $this->when = $this->getInterval($type);
        $this->route = $event->toUser;
        $this->notify(
            $type,
            $event->toUser,
            null,
            [
                'from' => $event->fromUser->uuid,
            ]
        );

        ContentCacheIsNotValidAnyMoreEvent::dispatch($event->toUser->information);
    }
}
