<?php

namespace Inside\Content\Listeners;

use Illuminate\Support\Facades\DB;
use Inside\Content\Exceptions\FieldSchemaNotFoundException;
use Inside\Content\Facades\ContentCache;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Content;
use Inside\Facades\Package;

/**
 * Base Content Listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class BaseContentListener
{
    protected function forgetCache(Content $model): void
    {
        $tags = ContentCache::getTags($model->content_type);
        $allowedFieldTypes = ['reference', 'comments', 'reactions'];

        $modelType = class_to_type($model);
        try {
            $fields = Schema::getFieldListing($modelType);
        } catch (FieldSchemaNotFoundException) {
            $fields = [];
        }

        foreach ($fields as $fieldName) {
            $fieldOptions = Schema::getFieldOptions($modelType, $fieldName);
            if (in_array($fieldOptions['type'], $allowedFieldTypes)) {
                $tags = array_merge($tags, (array) $fieldOptions['target']);
            }
        }

        ContentCache::forget($tags);
    }

    protected function clearCommentsCache($model): void
    {
        if ($model->content_type == 'comments') {
            $pivot = DB::table('inside_pivots')->where('related_uuid', $model->uuid)->first();
            if ($pivot->parent_uuid && $pivot->parent_type) {
                $parentModel = $pivot->parent_type::where('uuid', $pivot->parent_uuid)->first();
                $this->forgetCache($parentModel);
            }
        }
    }
}
