<?php

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Facades\AlphabetContent;
use Inside\Content\Models\Contents\AlphabetBooks;

class AlphabetContentUpdatedListener implements ShouldQueue
{
    public function handle(ContentFullyUpdatedEvent $event): void
    {
        $model = $event->model;

        if (get_class($model) === AlphabetBooks::class) {
            AlphabetContent::assignToCategory($model);
        }
    }
}
