<?php

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Facades\AlphabetContent;
use Inside\Content\Models\Contents\AlphabetBooks;

class AlphabetContentCreatedListener implements ShouldQueue
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        $model = $event->model;

        if (get_class($model) === AlphabetBooks::class) {
            AlphabetContent::assignToCategory($model);
        }
    }
}
