<?php

namespace Inside\Content\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Events\ContentPublishedEvent;
use Inside\Content\Models\Content;
use Inside\Jobs\Bus\Dispatchable;

/**
 * Class PublishContent
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class PublishContent implements ShouldQueue
{
    use Dispatchable;
    use Queueable;
    use SerializesModels;

    public function __construct(
        protected Content $content
    ) {
    }

    public function handle(): void
    {
        // trigger an event, our content is published !
        ContentPublishedEvent::dispatch($this->content);
    }
}
