<?php

namespace Inside\Content\Jobs;

use Illuminate\Support\Facades\Storage;
use Inside\Jobs\Job;

class DeleteFolder extends Job
{
    public function __construct(
        private string $disk,
        private string $folder,
    ) {
    }

    public function handle(): void
    {
        Storage::disk($this->disk)->deleteDirectory($this->folder);
    }
}
