<?php

declare(strict_types=1);

namespace Inside\Content\Jobs;

use Exception;
use Inside\Content\Models\WysiwygImage;
use Inside\Jobs\Job;

final class CleanupWysiwygImages extends Job
{
    /**
     * @throws Exception
     */
    public function handle(): void
    {
        WysiwygImage::whereNull('imageable_type')
            ->whereNull('imageable_id')
            ->where('created_at', '<', now()->subHour())
            ->delete();
    }
}
