<?php

declare(strict_types=1);

namespace Inside\Content\Jobs;

use Illuminate\Console\OutputStyle;
use Inside\Content\Contracts\QueryHelper;
use Inside\Content\Contracts\RevisionService;
use Inside\Jobs\Job;

final class AddRevisionOnExistingContentsIfNeeded extends Job
{
    public function __construct(
        protected ?OutputStyle $output = null
    ) {
    }

    public function handle(RevisionService $revisionService, QueryHelper $queryHelper): void
    {
        foreach ($revisionService->getSupportedContentTypes() as $type) {
            $this->output && $this->output->writeln(__(
                '<fg=magenta>#> :type</>',
                [
                    'type' => $type,
                ]
            ));
            $contents = $queryHelper->all($type);
            $this->output && $this->output->progressStart(count($contents));
            foreach ($contents as $content) {
                if (is_null($content->current_revision)) {
                    InitRevisionForContent::dispatch($content);
                }
                $this->output && $this->output->progressAdvance();
            }
            $this->output && $this->output->progressFinish();
        }
    }
}
