<?php

declare(strict_types=1);

namespace Inside\Content\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Inside\Authentication\Models\User;

/** @mixin User */
final class UserResource extends JsonResource
{
    public static $wrap = null;

    public function toArray($request): array
    {
        return [
            'uuid' => $this->uuid,
            'full_name' => $this->full_name,
            'email' => $this->email,
        ];
    }
}
