<?php

declare(strict_types=1);

namespace Inside\Content\Http\Requests;

use Inside\Content\Validation\Rules\ContentExistsRule;
use Inside\Content\Validation\Rules\ContentFieldExistsRule;
use Inside\Content\Validation\Rules\RecursiveRules;
use Inside\Http\Requests\FormRequest;

final class ContentCollectionOrderRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'items' => 'required|array',
            'items.*' => [
                new ContentFieldExistsRule('parent_field'),
                new ContentFieldExistsRule('order_field'),
                new ContentExistsRule(),
            ],
            'items.*.uuid' => 'required|string',
            'items.*.content_type' => 'required|string',
            'items.*.order_field' => 'string',
            'items.*.parent_field' => 'string',
            'items.*.children' => 'array',
            'items.*.children.*' => [
                new ContentFieldExistsRule('parent_field'),
                new ContentFieldExistsRule('order_field'),
                new ContentExistsRule(),
                new RecursiveRules(
                    rules: [
                        'uuid' => 'required|string',
                        'content_type' => 'required|string',
                        'parent_field' => 'required|string',
                        'order_field' => 'string',
                        'children' => 'array',
                        'children.*' => [
                            new ContentFieldExistsRule('parent_field'),
                            new ContentFieldExistsRule('order_field'),
                            new ContentExistsRule(),
                        ],
                    ],
                    recursiveField: 'children',
                ),
            ],
        ];
    }
}
