<?php

namespace Inside\Content\Http\Middlewares;

use Illuminate\Http\Request;
use Inside\Content\Contracts\WysiwygImageService;
use Inside\Http\Middleware\TransformResponseAndRequest;

class AddWysiwygImagesOnContentForm extends TransformResponseAndRequest
{
    protected array $paths = [
        'GET' => [
            '#^api/v1/form/(.*)?$#',
        ],
    ];

    /**
     * Patch response
     */
    protected function patch(Request $request, mixed $response, array $data = []): mixed
    {
        $matches = [];
        $images = [];
        if (preg_match(
            '#^api/v1/form/([^/]+)/([\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})$#',
            $request->path(),
            $matches
        ) > 0) {
            $content = call_user_func(type_to_class($matches[1]).'::find', $matches[2]);
            if ($content) {
                $wysiwygImageService = app()->make(WysiwygImageService::class);
                $images = $content->images->pluck('url')->transform(function ($url) use ($wysiwygImageService) {
                    return $wysiwygImageService->getRelativePath($url);
                });
            }
        }

        /** @var array|null $responseData */
        $responseData = json_decode_response($response);
        if ($responseData === null) {
            return $response;
        }
        $responseData['metadata'] = array_merge($responseData['metadata'] ?? [], [
            'wysiwyg_images' => $images,
        ]);
        set_response($response, $responseData);

        return $response;
    }
}
