<?php

namespace Inside\Content\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentCache;
use Laravel\Lumen\Routing\Controller;

class UserContentSeenController extends Controller
{
    public function __invoke(Request $request, string $type): JsonResponse
    {
        $currentUser = Auth::user();
        if (! $currentUser instanceof User) {
            return response()->json(['error' => 'Unauthorized'], 403);
        }
        $userUuid = $currentUser->uuid;

        $contentUuid = $request->input('uuid_host');
        if (! $contentUuid) {
            return response()->json(['error' => 'Type and uuid is required !'], 400);
        }

        if (! Schema::hasTable('inside_user_content_seen')) {
            return response()->json(['error' => 'content seen table does not exist!'], 500);
        }

        $contentTypeClass = type_to_class($type);
        $existingRecord = DB::table('inside_user_content_seen')
            ->where('user_uuid', $userUuid)
            ->where('seen_type', $contentTypeClass)
            ->where('seen_uuid', $contentUuid)
            ->first();

        if (! $existingRecord) {
            DB::table('inside_user_content_seen')->insert([
                'user_uuid' => $userUuid,
                'seen_type' => $contentTypeClass,
                'seen_uuid' => $contentUuid,
            ]);

            ContentCache::forget([$type]);

            return response()->json(['message' => 'User content seen created.'], 201);
        }

        return response()->json(['message' => 'User already seen this content !'], 200);
    }
}
