<?php

namespace Inside\Content\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Models\ShortUrl;

class ShortUrlController
{
    public function __invoke(Request $request, string $key): JsonResponse
    {
        $url = ShortUrl::findByKey($key);

        if (is_null($url)) {
            abort(404);
        }

        /** @var ShortUrl $url */
        $targetUrl = $url->destination_url;
        if ($url->forward_query_params) {
            $targetUrl = $this->getParamsFromQuery($request, $url);
        }

        return response()->json([
            'url' => $targetUrl,
        ]);
    }

    protected function getParamsFromQuery(Request $request, ShortUrl $url): string
    {
        $queryString = parse_url($url->destination_url, PHP_URL_QUERY);

        if (empty($request->query())) {
            return $url->destination_url;
        }

        $separator = $queryString ? '&' : '?';

        return $url->destination_url.$separator.http_build_query((array) $request->query());
    }
}
