<?php

namespace Inside\Content\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Events\SeniorityAnniversaryWishesSendEvent;
use Laravel\Lumen\Routing\Controller;

/**
 * Say yes
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SeniorityAnniversaryController extends Controller
{
    public function notify(string $toUser): JsonResponse
    {
        $toUser = User::find($toUser);
        /** @var User $fromUser */
        $fromUser = Auth::user();
        $success = false;
        if ($fromUser->uuid != $toUser->uuid) {
            SeniorityAnniversaryWishesSendEvent::dispatch($fromUser, $toUser);
            $success = true;
        }

        return response()->json(
            [
                'success' => $success,
            ]
        );
    }
}
