<?php

namespace Inside\Content\Http\Controllers\Resource;

use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

final class ServePublic extends Controller
{
    public function __invoke(string $path): BinaryFileResponse
    {
        // Url decode path
        $path = urldecode($path);

        $disk = Storage::disk('public');

        $headers = [];
        if ($disk->mimeType($path) == 'application/pdf') {
            $headers['Accept-Ranges'] = 'none';
        }

        // Finally serve the resource
        return new BinaryFileResponse($disk->path($path), 200, $headers);
    }
}
