<?php

namespace Inside\Content\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Inside\Content\Http\Requests\ReportStoreRequest;
use Inside\Content\Jobs\ReportContent;
use Laravel\Lumen\Routing\Controller;

class Report extends Controller
{
    public function __invoke(ReportStoreRequest $request): JsonResponse
    {
        $safeData = $request->safe();
        $reason = $request->has('reason') ? $request->get('reason') : false;

        ReportContent::dispatch($safeData['contentType'], $safeData['uuid'], $reason, Auth::user());

        return response()->json(
            [
                'success' => true,
            ]
        );
    }
}
