<?php

namespace Inside\Content\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\ConnexionPopups;
use Inside\Content\Services\PopinService;
use Inside\Reaction\Facades\Reactions;
use Inside\Reaction\Models\Reaction;
use Laravel\Lumen\Routing\Controller;

class PopinController extends Controller
{
    public function __construct(private PopinService $popinService)
    {
    }

    public function popin(Request $request): JsonResponse
    {
        /** @var string $filters */
        $filters = $request->query('filters') ?? '';
        $filters = json_decode($filters, true);
        $langcode = $filters['langcode'] ?? null;

        $recurrence = $request->input('popin_on_off', 'every_connection');

        return $this->popinService->getResponse(recurrence: $recurrence, langcode: $langcode);
    }

    public function reaction(Request $request): Reaction
    {
        /** @var User $user */
        $user = Auth::user();
        /** @var string $uuid */
        $uuid = $request->input('uuid');
        $popin = ConnexionPopups::findOrFail($uuid);
        $this->popinService->cleanPastReactions($popin);
        $viewedPopinReaction = Reaction::create([
            'user_uuid' => $user->uuid,
            'reactionable_uuid' => $uuid,
            'reactionable_type' => ConnexionPopups::class,
            'type' => 'popin',
            'langcode' => $popin->langcode,
        ]);

        return $viewedPopinReaction;
    }
}
