<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Inside\Support\Str;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\File\MimeType\MimeTypeGuesser;

class UploadFile extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        MimeTypeGuesser::reset();

        $maxSize = UploadedFile::getMaxFilesize();

        $this->validate(
            $request,
            [
                'type'  => 'string|alpha_dash',
                'asset' => 'required|file|mimes:jpeg,png,jpg,gif,mp4,pdf,svg|max:'.$maxSize,
            ]
        );

        $disk = Storage::disk('assets');

        if (! $request->has('asset')) {
            abort(500);
        }
        /** @var UploadedFile $asset */
        $asset = $request->file('asset');

        $file = $disk->putFileAs('inside-pages', $asset, Str::random(40).'.'.$asset->guessExtension());

        return response()->json([
            'url' => $disk->url($file),
            'name' => $asset->getClientOriginalName(),
            'size' => $asset->getSize(),
            'type' => $asset->getMimeType(),
        ]);
    }
}
