<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Cache;
use Inside\Content\Services\InsidePagesService;
use Laravel\Lumen\Routing\Controller;

class Publish extends Controller
{
    public function __invoke(int $id): JsonResponse
    {
        try {
            $page = InsidePagesService::publishPage($id);

            $cacheKey = InsidePagesService::getPageCacheKeyFromPath($page->path, $page->langcode);
            Cache::forget($cacheKey);

            return response()->json([
                'message' => 'Page published successfully.',
                'data' => $page,
            ]);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'message' => 'Page not found !',
                'error' => 404,
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'message' => $e->getMessage(),
            ], 500);
        }
    }
}
