<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Http\JsonResponse;
use Inside\Content\Services\InsidePagesService;
use Laravel\Lumen\Routing\Controller;

class Duplicate extends Controller
{
    public function __invoke(int $id): JsonResponse
    {
        try {
            $newPage = InsidePagesService::duplicatePage($id);

            return response()->json([
                'message' => 'Page duplicated successfully.',
                'data' => $newPage,
            ]);
        } catch (\Exception $e) {
            \Log::error($e->getMessage());

            return response()->json(['message' => 'Failed to duplicate page.'], 500);
        }
    }
}
