<?php

declare(strict_types=1);

namespace Inside\Content\Http\Controllers\External;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Contracts\ContentExternalList;
use Inside\Permission\Facades\Permission;

final class Index extends Controller
{
    /**
     * @throws \Exception
     */
    public function __invoke(string $type, Request $request, ContentExternalList $list): JsonResponse
    {
        $type = $this->checkContentType($type);
        Permission::disableAllowedScope();
        $fields = config('external_api.inside_external_api_fields')[$type];

        $result = $list($type, $request, $fields);

        $transform = config('external_api.inside_external_api_transform');
        if (! is_null($transform)) {
            if (! is_callable($transform)) {
                throw new \Exception('The result transformer must be a callable function !');
            }
            $result = $transform($result);
        }

        Permission::enableAllowedScope();

        return new JsonResponse($result, 200, ['Content-Type', 'application/json']);
    }
}
