<?php

declare(strict_types=1);

namespace Inside\Content\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Routing\Controller;
use Inside\Content\Contracts\ContentCollectionOrderManager;
use Inside\Content\DTO\ContentOrderedItemDTO;
use Inside\Content\Http\Requests\ContentCollectionOrderRequest;

final class ContentCollectionOrderController extends Controller
{
    public function __invoke(ContentCollectionOrderRequest $request, ContentCollectionOrderManager $orderManager): JsonResponse
    {
        $inputs = $request->safe();

        $items = ContentOrderedItemDTO::from($inputs['items']);

        $orderManager->updateContentsOrder($items);

        return response()->json(['ordered' => true]);
    }
}
