<?php

namespace Inside\Content\Facades;

use Illuminate\Support\Facades\Facade;
use Inside\Content\Contracts\ContentBlueprints as ContentBlueprintsContract;

/**
 * @method static bool isBundleInstalled(string $bundle)
 * @method static void generateBundle(string $bundle, array $overrides = [], bool $deleteBefore = false)
 * @method static void generateContent(string $contentType, array $overrides = [], bool $deleteBefore = false, ?string $bundle = null)
 * @method static bool hasContentConfiguration(string $contentType, ?string $bundle = null)
 * @method static string getContentBlueprintFilePath(string $contentType, ?string $bundle = null)
 */
class ContentBlueprints extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return ContentBlueprintsContract::class;
    }
}
