<?php

namespace Inside\Content\Exceptions;

use InvalidArgumentException;

/**
 * SchemaNotFoundException
 *
 * The model schema does not exist
 *
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
final class SchemaNotFoundException extends InvalidArgumentException
{
    public static function named(string $modelName): self
    {
        return new self("There is no schema set for model named `{$modelName}`.");
    }
}
