<?php

namespace Inside\Content\Exceptions;

use InvalidArgumentException;

/**
 * ModelSchemaNotFoundException
 *
 * The model dooes not exist
 *
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
final class ModelSchemaNotFoundException extends InvalidArgumentException
{
    public static function named(string $modelName): self
    {
        return new self("There is no model named `{$modelName}`.");
    }
}
