<?php

declare(strict_types=1);

namespace Inside\Content\Events;

use Inside\Content\Models\Content;
use Inside\Content\Models\Section;
use Inside\Events\Dispatchable;

final class ProcessingUpdate
{
    use Dispatchable;

    public function __construct(
        public Content|Section $content,
        protected array $dirty = []
    ) {
        $this->dirty = $this->content->getDirty();
    }

    /** @return array<string, mixed> */
    public function getDirty(): array
    {
        return $this->dirty;
    }
}
