<?php

declare(strict_types=1);

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Revision;
use Inside\Events\Dispatchable;

final class NewRevision implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels, Dispatchable;

    public function __construct(
        public Revision $revision
    ) {
    }

    /**
     * @return array<int, PrivateChannel>
     */
    public function broadcastOn(): array
    {
        $privateChannel = [];
        if (! is_null($this->revision->content->creator)) {
            $privateChannel = [new PrivateChannel('inside.revisions.'.$this->revision->content->creator->uuid)];
        }

        if (
            ! is_null($this->revision->content->modificator)
            && $this->revision->content->modificator->uuid !== $this->revision->content->author_id
        ) {
            $privateChannel = [new PrivateChannel('inside.revisions.'.$this->revision->content->modificator->uuid)];
        }

        return [
            ...$privateChannel,
            new PrivateChannel('inside.revisions'),
        ];
    }

    public function broadcastAs(): string
    {
        return 'inside.revision.created';
    }
}
