<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

/**
 * Class ImportCompletedEvent
 */
class ImportCompletedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * ImportCompletedEvent constructor.
     */
    public function __construct(
        public array $config,
        public User $user
    ) {
    }

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside.import.'.$this->user->uuid);
    }

    public function broadcastAs(): string
    {
        return 'inside.import.completed';
    }

    public function broadcastWith(): array
    {
        return [
            'config' => $this->config,
        ];
    }
}
