<?php

declare(strict_types=1);

namespace Inside\Content\Events;

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Content updating event.
 *
 * Note : we should not SerializesModels updating model
 *
 * @author   Maecia <technique@maecia.com>
 * @link     http://www.maecia.com/
 */
final class ContentUpdatingEvent
{
    use Dispatchable;

    public ?User $user;

    /**
     * Create a new content updated event instance.
     */
    public function __construct(
        public Content $model
    ) {
        /** @var ?User $user */
        $user = Auth::user();
        $this->user = $user;
    }
}
