<?php

namespace Inside\Content\Events;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Content updated event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentUpdatedEvent
{
    use SerializesModels, Dispatchable;

    public ?User $user;

    /**
     * Create a new content updated event instance.
     */
    public function __construct(
        public Content $model
    ) {
        /** @var ?User $user */
        $user = Auth::user();
        $this->user = $user;
    }
}
