<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Content published event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentPublishedEvent implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels, Dispatchable;

    /**
     * Create a new content created event instance.
     */
    public function __construct(
        public Content $model
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     * @return array<int, PrivateChannel>
     */
    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('inside.contents.'.$this->model->author),
            new PrivateChannel('inside.contents.'.class_to_type($this->model).'.'.$this->model->author),
        ];
    }

    public function broadcastAs(): string
    {
        return 'inside.content.published';
    }
}
