<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Content\Models\Section;
use Inside\Events\Dispatchable;

/**
 * Sections attached event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentFullyUpdatedEvent implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels, Dispatchable;

    public function __construct(
        public Content|Section $model,
        public ?User $author
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     * @return array<int, PrivateChannel>
     */
    public function broadcastOn(): array
    {
        if ($this->model instanceof Section) {
            return [];
        }

        return [
            new PrivateChannel('inside.contents.'.$this->model->author),
            new PrivateChannel('inside.contents.'.class_to_type($this->model).'.'.$this->model->author),
        ];
    }

    public function broadcastAs(): string
    {
        return 'inside.content.updated';
    }
}
