<?php

namespace Inside\Content\Events;

use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Field;
use Inside\Events\Dispatchable;

/**
 * Content field updated event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentFieldUpdatedEvent
{
    use SerializesModels, Dispatchable;

    /**
     * Create a new content updated event instance.
     */
    public function __construct(
        public Field $field
    ) {
    }
}
