<?php

namespace Inside\Content\Events;

use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Field;
use Inside\Events\Dispatchable;

/**
 * Content created event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentFieldCreatedEvent
{
    use SerializesModels;
    use Dispatchable;

    /**
     * Create a new content field created event instance.
     */
    public function __construct(
        public Field $field
    ) {
    }
}
