<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Support\Facades\Auth;

/**
 * Content deleted event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentDeletedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;

    public ?Authenticatable $user;

    /**
     * Create a new content deleted event instance.
     *
     * @param  mixed  $model
     */
    public function __construct(
        public mixed $model
    ) {
        $this->user = Auth::user();
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('inside.contents.'.$this->model->author),
            new PrivateChannel('inside.contents.'.class_to_type($this->model).'.'.$this->model->author),
        ];
    }

    /**
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'inside.content.deleted';
    }
}
