<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Comments;
use Inside\Events\Dispatchable;

/**
 * Comment created event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CommentCreatedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * A comment is created in a certain way in drupal, it's first saved then it is attached
     * to a content
     *
     * A comment can be used only when those two steps have been performed
     */
    public function __construct(
        public Comments $comment,
        public Content $parent
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside_content.'.class_to_type($this->parent).'.'.$this->parent->uuid);
    }

    /**
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'inside_content.comments.created';
    }
}
