<?php

declare(strict_types=1);

namespace Inside\Content\Contracts;

use Illuminate\Http\UploadedFile;
use Inside\Content\Models\Content;
use Inside\Content\Models\WysiwygImage;

interface WysiwygImageService
{
    public function upload(UploadedFile $file, string $relativePath = '/'): string;

    public function store(Content $content, array $urls): bool;

    public function load(string $path): ?WysiwygImage;

    public function getRelativePath(string $fullUrl): string;

    public function translate(Content $contentSource, Content $contentDestination, WysiwygImage $wysiwygImage): void;
}
