<?php

namespace Inside\Content\Contracts;

interface ContentBlueprints
{
    public function isBundleInstalled(string $bundle): bool;

    public function generateBundle(string $bundle, array $overrides = [], bool $deleteBefore = false): void;

    public function generateContent(string $contentType, array $overrides = [], bool $deleteBefore = false, ?string $bundle = null): void;

    public function hasContentConfiguration(string $contentType, ?string $bundle = null): bool;

    public function getContentBlueprintFilePath(string $contentType, ?string $bundle = null): string;
}
