<?php

namespace Inside\Content\Console;

use Illuminate\Support\Arr;
use Inside\Console\Command;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Permission\Models\Role;

class ReplaceUuidsWithHostInRolesTableCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:roles:replace-uuids';

    /**
     * @var string
     */
    protected $signature = 'inside:roles:replace-uuids';

    /**
     * @var string
     */
    protected $description = 'Replace uuids with uuid host in inside roles table';

    public function handle(): void
    {
        Role::whereNotNull('condition')->each(function (Role $role) {
            if (! str($role->condition)->contains(':')) {
                $role->condition = null;
                $role->is_automatic = false;
                $role->save();

                return;
            }

            /** @phpstan-ignore-next-line */
            [$fieldName, $uuids] = explode(':', $role->condition);

            $fieldOptions = Schema::getFieldOptions('users', $fieldName);

            if ($fieldOptions['type'] !== 'reference') {
                return;
            }

            $uuids = explode('&', $uuids);
            $newCondition = $this->buildUuidHostCondition($uuids, $fieldOptions);
            if ($newCondition) {
                $role->condition = $newCondition;
                $role->save();
            }
        });
    }

    private function buildUuidHostCondition(array $uuids, array $fieldOptions) : string
    {
        $target = Arr::first($fieldOptions['target']);
        $uuid_hosts = collect($uuids)
            ->map(fn (string $uuid) => call_user_func(type_to_class($target).'::query')->where('uuid', $uuid)->first()?->uuid_host)
            ->filter()
            ->unique()
            ->values()
            ->join('&');

        if (empty($uuid_hosts)) {
            return '';
        }

        return "$target:$uuid_hosts";
    }
}
