<?php

namespace Inside\Content\Console;

use Illuminate\Console\Command;
use Inside\Content\Facades\Schema;
use Inside\Host\Actions\RepairFieldMaxFilesize;
use Inside\Host\Bridge\BridgeContentType;

class RepairUploadLimitCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:repair:upload-limit';

    /**
     * @var string
     */
    protected $signature = 'inside:repair:upload-limit';

    /**
     * @var string
     */
    protected $description = 'Réenregistrement des champs Drupal pour utiliser le upload_max_filesize de PHP';

    protected BridgeContentType $bridge;

    public function handle(): void
    {
        $this->bridge = new BridgeContentType();

        $this->getOutput()->writeln('<fg=blue>Configuration actuelle de PHP: '.ini_get('upload_max_filesize').'</fg=blue>');

        $this->updateFieldsOfType('image');
        $this->updateFieldsOfType('file');
    }

    private function updateFieldsOfType(string $type): void
    {
        $this->getOutput()->writeln("<fg=yellow>Mise à jour des champs de type $type.</fg=yellow>");

        $action = new RepairFieldMaxFilesize();

        collect(Schema::getAllFieldsListingOfType($type))
            ->transform(fn (array $attributes, $contentType) => collect($attributes)->crossJoin($contentType))
            ->flatten(1)
            ->each(fn (array $toUpdate) => $this->getOutput()->writeln(
                $action->repair(
                    type: $toUpdate[1],
                    field: $toUpdate[0],
                    storage: Schema::isContentType($toUpdate[1]) ? 'node' : 'paragraph'
                )
            ));
    }
}
