<?php

namespace Inside\Content\Console\Paragraphs;

use Illuminate\Support\Collection;
use Inside\Console\Command;
use Inside\Content\Contracts\SchemaService;
use Inside\Host\Bridge\BridgeContentType;

class MakeRattachedBundlesTranslatable extends Command
{
    protected $signature = 'inside:paragraph:bundles:translatable';

    protected $description = 'Enable translation for Content Type with Paragraphs';

    protected SchemaService $schemaService;

    public function __construct()
    {
        parent::__construct();
        $this->schemaService = app()->make(SchemaService::class);
    }

    public function handle(): void
    {
        $bridge = new BridgeContentType();

        collect($this->getUntranslatableBundlesWithParagraphs())
            ->keys()
            ->each(function (string $bundle) use ($bridge) {
                $this->writeln('<fg=yellow>Updating</>: '.$bundle);

                $bridge->updateContentTypeOptions($bundle, ['translation' => true]);

                $this->writeln('<fg=green>Updated</>: '.$bundle);
            });
    }

    protected function getBundlesWithParagraphs(): array
    {
        $sections = $this->schemaService->getAllFieldsListingOfType('section');

        return collect($sections)->keys()->diff($this->schemaService->getSectionTypes())->toArray();
    }

    protected function getUntranslatableBundlesWithParagraphs(): array
    {
        return collect($this->getBundlesWithParagraphs())
            ->mapWithKeys(fn (string $bundle) => [
                $bundle => collect($this->schemaService->getModelOptions($bundle)),
            ])
            ->reject(fn (Collection $options) => $options->get('translatable'))
            ->toArray();
    }
}
